document.getElementById("searchBox").addEventListener("click", function(){
    this.classList.add("expanded");
    document.getElementById("searchInput").focus();
});
document.addEventListener("click", function (event){
    let searchBox = document.getElementById("searchBox");
    if (!searchBox.contains(event.target)) {
        searchBox.classList.remove("expanded");
    }
});

document.getElementById("searchBoxsm").addEventListener("click", function(){
    this.classList.add("expanded");
    document.getElementById("searchInputsm").focus();
});
document.addEventListener("click", function(event){
    let searchBox = document.getElementById("searchBoxsm");
    if (!searchBox.contains(event.target)){
        searchBox.classList.remove("expanded");
    }
});

document.addEventListener("DOMContentLoaded", function(){
    const images = [
        "images/news1.png",
        "images/news2.png",
        "images/news3.png",
    ];
    let currentIndex = 0;
    const imageElement = document.querySelector(".news-slider-img");
    const leftButton = document.querySelector(".news-slider:first-child");
    const rightButton = document.querySelector(".news-slider:last-child");
    leftButton.addEventListener("click", (event) =>{
        event.preventDefault();
        currentIndex = (currentIndex === 0) ? images.length - 1 : currentIndex - 1;
        updateImage();
    });
    rightButton.addEventListener("click", (event) =>{
        event.preventDefault();
        currentIndex = (currentIndex === images.length - 1) ? 0 : currentIndex + 1;
        updateImage();
    });
    function updateImage(){
        imageElement.src = images[currentIndex];
    }
});

document.addEventListener('DOMContentLoaded', function(){
    const slides = [
        {
            image: 'images/news1.png',
            title: 'راه اندازی خانه خلاق شهرستان اسدیه در دستور کار',
            description: 'به گزارش روابط عمومی و امور بین الملل پارک علم و فناوری خراسان ...'
        },
        {
            image: 'images/news2.png',
            title: 'راه اندازی خانه خلاق شهرستان اسدیه در دستور کار',
            description: 'به گزارش روابط عمومی و امور بین الملل پارک علم و فناوری خراسان ...'
        },
        {
            image: 'images/news3.png',
            title: 'راه اندازی خانه خلاق شهرستان اسدیه در دستور کار',
            description: 'به گزارش روابط عمومی و امور بین الملل پارک علم و فناوری خراسان ...'
        }
    ];
    let currentIndex = 2;
    const prevBtn = document.querySelector('.prev-btn');
    const nextBtn = document.querySelector('.next-btn');
    const newsImage = document.querySelector('.news-slider-img-sm');
    const newsTitle = document.querySelector('.text-slider-top');
    const newsDesc = document.querySelector('.text-slider-bottom');
    function updateSlide(){
        newsImage.src = slides[currentIndex].image;
        newsTitle.textContent = slides[currentIndex].title;
        newsDesc.textContent = slides[currentIndex].description;
    }
    prevBtn.addEventListener('click', function(e){
        e.preventDefault();
        currentIndex = (currentIndex - 1 + slides.length) % slides.length;
        updateSlide();
    });
    nextBtn.addEventListener('click', function(e){
        e.preventDefault();
        currentIndex = (currentIndex + 1) % slides.length;
        updateSlide();
    });
});

(function() {
    const navBottom = document.getElementById('navBottom');
    const navTop = document.getElementById('navTop');
    const navImgBox = document.querySelector('.nav-img-box');
    let isFixed = false;
    const topSectionHeight = navTop.offsetHeight;
    function handleScroll(){
        const scrollY = window.scrollY || window.pageYOffset;
        if (scrollY > topSectionHeight && !isFixed){
            navBottom.classList.add('fixed');
            navImgBox.classList.add('nav-img-scroll');
            document.body.style.paddingTop = navBottom.offsetHeight + 'px';
            isFixed = true;
        } 
        else if (scrollY <= topSectionHeight && isFixed){
            navBottom.classList.remove('fixed');
            navImgBox.classList.remove('nav-img-scroll');
            document.body.style.paddingTop = '0';
            isFixed = false;
        }
    }
    let ticking = false;
    window.addEventListener('scroll', function(){
        if (!ticking) {
            window.requestAnimationFrame(function(){
                handleScroll();
                ticking = false;
            });
            ticking = true;
        }
    });
    window.addEventListener('resize', function(){
        document.body.style.paddingTop = isFixed ? navBottom.offsetHeight + 'px' : '0';
    });
})();

(function(){
    const navBottom = document.getElementById('navBottomsm');
    const navTop = document.getElementById('navTopsm');
    const navImgBox = document.querySelector('.nav-img-box-sm');
    let isFixed = false;
    const topSectionHeight = navTop.offsetHeight;
    function handleScroll(){
        const scrollY = window.scrollY || window.pageYOffset;
        if(scrollY > topSectionHeight && !isFixed){
            navBottom.classList.add('fixed');
            navImgBox.classList.add('nav-img-scroll-sm');
            document.body.style.paddingTop = navBottom.offsetHeight + 'px';
            isFixed = true;
        } 
        else if(scrollY <= topSectionHeight && isFixed){
            navBottom.classList.remove('fixed');
            navImgBox.classList.remove('nav-img-scroll-sm');
            document.body.style.paddingTop = '0';
            isFixed = false;
        }
    }
    let ticking = false;
    window.addEventListener('scroll', function(){
        if (!ticking){
            window.requestAnimationFrame(function(){
                handleScroll();
                ticking = false;
            });
            ticking = true;
        }
    });
    window.addEventListener('resize', function() {
        document.body.style.paddingTop = isFixed ? navBottom.offsetHeight + 'px' : '0';
    });
})();